import ika
import math
import system
import engine
import player
import Brain
import animator
import sound
import dir

from enemy import Enemy
from entity import Entity

_beeAnim = {
    'walk': ((
        animator.makeAnim((4, 5), 3),
        animator.makeAnim((6, 7), 3),
        animator.makeAnim((2, 3), 3),
        animator.makeAnim((0, 1), 3),
        animator.makeAnim((4, 5), 3),
        animator.makeAnim((6, 7), 3),
        animator.makeAnim((4, 5), 3),
        animator.makeAnim((6, 7), 3),
        ),
        True
    ),

    'idle': ((
        animator.makeAnim((4, 5), 3),
        animator.makeAnim((6, 7), 3),
        animator.makeAnim((2, 3), 3),
        animator.makeAnim((0, 1), 3),
        animator.makeAnim((4, 5), 3),
        animator.makeAnim((6, 7), 3),
        animator.makeAnim((4, 5), 3),
        animator.makeAnim((6, 7), 3),
        ),
        True
    ),

    'attack': ((
        ((12, 30), (13, 15)),
        ((14, 30), (15, 15)),
        ((10, 30), (11, 15)),
        (( 8, 30), ( 9, 15)),
        ((12, 30), (13, 15)),
        ((14, 30), (15, 15)),
        ((12, 30), (13, 15)),
        ((14, 30), (15, 15)),
        ),
        False
    ),

    'hurt': ((
        ((27, 1000),),
        ((26, 1000),),
        ((24, 1000),),
        ((25, 1000),),
        ((27, 1000),),
        ((26, 1000),),
        ((27, 1000),),
        ((26, 1000),),
        ),
        False
    ),

    'die': ((
        ((38, 20), (39, 90)),
        ((33, 20), (34, 90)),
        ((23, 20), (24, 90)),
        ((28, 20), (29, 90)),
        ((38, 20), (39, 90)),
        ((33, 20), (34, 90)),
        ((38, 20), (39, 90)),
        ((33, 20), (34, 90)),
        ),
        False
    ),
}

_attackRange = [
    (-8,   0,  8, 16),
    (16,   0,  8, 16),
    ( 0, -8,  16,  8),
    ( 0,  16, 16,  8),
    (-8,   0,  8, 16),
    (16,   0,  8, 16),
    (-8,   0,  8, 16),
    (16,   0,  8, 16),
]


def createBee(entity):
    return Bee(entity)


class Bee(Enemy):

    SPRITE = 'bee.ika-sprite'

    def __init__(self, ent):
        super(Bee, self).__init__(ent, _beeAnim, Brain.Brain())

        # Test code:
        # Equal probability of attacking or doing nothing.
        #self.addMoods(
        #    (Brain.Attack(1), self.attackMood),
        #    (Brain.Flee(1), self.passiveMood)
        #)

        self.mood = self.passiveMood
        self.stats.maxhp = self.stats.hp = 5
        self.stats.att = 1
        self.stats.exp = 1

        self.stats.money = 1

        self.speed = 125

        self.adjustStats()

    def hurtState(self, recoilSpeed, recoilDir):
        if self.stats.hp > 0:
            sound.enemyHit.Play()

        return super(Bee, self).hurtState(recoilSpeed, recoilDir)

    def die(self, *args):
        super(Bee, self).die(*args)

    def fleeMood(self):
        MIN_DIST = 150
        p = system.engine.player
        for q in range(5):
            d = dir.fromDelta(p.x - self.x, p.y - self.y)
            dist = math.hypot(p.x - self.x, p.y - self.y)
            if dist > MIN_DIST:
                break
            yield self.walkState(dir.invert[d], MIN_DIST - dist)
        self.mood = self.passiveMood
        yield self.idleState()

    def passiveMood(self):

        p = system.engine.player
        self._animator.kill = True
        while True:
            yield self.walkState(ika.Random(0,8), ika.Random(8,32))

            tx = (self.ent.x + self.ent.hotwidth) / ika.Tileset.width
            ty = (self.ent.y + self.ent.hotheight) / ika.Tileset.height

            # if on a flower, sit there
            if ika.Map.GetTile(tx, ty, self.ent.layer) in [356, 357, 358, 364, 365, 366]:
                yield self.idleState(400)
            else:
                yield self.idleState(ika.Random(0,10))


    def idleState(self, *args):
        self._animator.kill = True
        return super(Bee, self).idleState(*args)

    def walkState(self, dir, dist):
        ox, oy = self.x, self.y
        self.move(dir, dist)
        self.anim = 'walk'
        yield None
        while self.moving:
            ents = self.detectCollision((0, 0, self.ent.hotwidth, self.ent.hotheight))
            for e in ents:
                if isinstance(e, player.Player):
                    d = max(1, self.stats.att - e.stats.pres)
                    e.hurt(d, 100, self.direction)
                    break
            if (ox, oy) == (self.x, self.y):
                break
            yield None
        self.stop()

    def deathState(self, *args, **kwargs):
        sound.beeDie.Play()
        self.anim = 'die'
        return super(Bee, self).deathState(*args, **kwargs)
