import config
from entities import *
from obstacle import IceWall, Gap, IceChunks, Boulder
from savepoint import SavePoint
from smith import Smith
from yolander import Yolander
from townguy2 import Townguy2
from townguy3 import Townguy3
from towndancer import Dancer
from townwoman import Townwoman
from friedrich import Friedrich

# GREEN ENEMIES
import bee
import goblin
import plant

# GREEN GENERATORS
import hive

# LEVEL1 ENEMIES
import bug
import jelly
import frankenhead

# LEVEL1 GENERATORS
import pot

# BOSSES
import maneater


# match each sprite name up with the associated class
spawnMap = {

    bee.Bee.SPRITE : bee.createBee,
    goblin.Goblin.SPRITE : goblin.createGoblin,
    goblin.UberGoblin.SPRITE : goblin.createUberGoblin,
    goblin.DesertGoblin.SPRITE : goblin.createDesertGoblin,
    plant.Plant.SPRITE : plant.createPlant,

    hive.Hive.SPRITE : hive.createHive,

    bug.Bug.SPRITE : bug.createBug,
    jelly.Jelly.SPRITE : jelly.createJelly,
    frankenhead.Frankenhead.SPRITE : frankenhead.createFrankenhead,

    pot.Pot.SPRITE : pot.createPot,

    maneater.Maneater.SPRITE : maneater.Maneater,

    # -------------------

    Gap.SPRITE: Gap,
    Gap.SPRITE2: Gap,
    Gap.SPRITE3: Gap,

    Smith.SPRITE : Smith,
    SavePoint.SPRITE : SavePoint,
    Yolander.SPRITE : Yolander,
    Townguy2.SPRITE : Townguy2,
    Townguy3.SPRITE : Townguy3,
    Dancer.SPRITE : Dancer,
    Dancer.SPRITE2 : Dancer,
    Friedrich.SPRITE : Friedrich,
    Townwoman.SPRITE : Townwoman
}

'''spawnMap = {
    AnkleBiter.SPRITE: AnkleBiter,
    Boulder.SPRITE: Boulder,
    Carnivore.SPRITE: Carnivore,
    CowardRune.SPRITE: CowardRune,
    Devourer.SPRITE: Devourer,
    DragonPup.SPRITE: DragonPup,
    Dynamite.SPRITE: Dynamite,
    FireRune.SPRITE: FireRune,
    Gap.SPRITE: Gap,
    Gap.SPRITE2: Gap,
    Gorilla.SPRITE: Gorilla,
    GuardRune.SPRITE: GuardRune,
    HellHound.SPRITE: HellHound,
    IceChunks.SPRITE: IceChunks,
    IceWall.SPRITE: IceWall,
    IceWall.SPRITE2: IceWall,
    PowerRune.SPRITE: PowerRune,
    RazorMane.SPRITE: RazorMane,
    SavePoint.SPRITE: SavePoint,
    Serpent.SPRITE: Serpent,
    SoulReaver.SPRITE: SoulReaver,
    StrengthRune.SPRITE: StrengthRune,
    WaterRune.SPRITE: WaterRune,
    WindRune.SPRITE: WindRune,
    Yeti.SPRITE: Yeti,
}'''


class SpawnException(Exception):
    pass


def createEntity(spriteName, *args, **kw):
    assert (isinstance(spriteName, basestring),
            "createEntity: spriteName must be a string, not '%r'" %
            type(spriteName))
    if spriteName not in spawnMap:
        raise SpawnException("Don't know how to create entity '%s'" %
                             spriteName)
    factory = spawnMap[spriteName]
    return factory(*args, **kw)
