import ika
import config
import controls
import subscreen
import sound
from engine import font
from snow import Snow


class _DoneException(Exception):
    pass


def delay(draw, count):
    while count > 0:
        draw()
        ika.Delay(1)
        count -= 1
        ika.Video.ShowPage()
        ika.Input.Update()
        if controls.attack1():
            raise _DoneException()


def intro():
    ikalogo = ika.Image('%s/ika.png' % config.IMAGE_PATH)
    gba = ika.Image('%s/gba.png' % config.IMAGE_PATH)
    yourmom = ika.Image('%s/yourmother.png' % config.IMAGE_PATH)
    isabitch = ika.Image('%s/yourmother2.png' % config.IMAGE_PATH)
    controls.attack1() # unpress
    v = ika.Video
    d = 40

    def showGba():
        v.ClearScreen()
        v.Blit(gba, (v.xres - gba.width) / 2, (v.yres - gba.height) / 2)

    try:
        delay(showGba, 300)
        delay(lambda: v.ClearScreen(), d)
        delay(lambda: v.Blit(ikalogo, 0, 0, ika.Opaque), 300)
        delay(lambda: v.ClearScreen(), d)
        delay(lambda: v.Blit(yourmom, 0, 0, ika.Opaque), 300)
        delay(lambda: v.Blit(isabitch, 0, 0, ika.Opaque), d)
        delay(lambda: v.ClearScreen(), d)
    except _DoneException:
        return


def menu():
    bg = ika.Image('%s/title_bg.png' % config.IMAGE_PATH)
    logo = ika.Image('%s/title_logo.png' % config.IMAGE_PATH)
    cursor = ika.Image('%s/ui/pointer.png' % config.IMAGE_PATH)
    result = None
    cursorPos = 0
    menuTop = 175
    menuLeft = 120
    secrat = 0
    menuItems = ("New Game", "Load Game", "Quit Game")
    wnd = subscreen.Window('gfx/ui/win_%s.png')
    FADE_TIME = 60

    def draw():
        ika.Video.Blit(bg, 0, 0, ika.Opaque)
        font.Print(2, 2, "v.1/05")
        ika.Video.Blit(logo, 0, 0)
        wnd.draw(menuLeft - 5, menuTop - 5, ika.Video.xres - (menuLeft * 2), (len(menuItems) * font.height) + 10)
        y = 0
        for i in menuItems:
          font.Print(menuLeft, menuTop + y, i)
          y += font.height
        ika.Video.Blit(cursor, menuLeft - cursor.width - 2, menuTop + cursorPos * font.height + 2)

    for i in range(FADE_TIME - 1, -1, -1):
        draw()
        ika.Video.DrawRect(0, 0, ika.Video.xres, ika.Video.yres,
                           ika.RGB(0, 0, 0, i * 255 / FADE_TIME), True)
        ika.Video.ShowPage()
        ika.Input.Update()
        ika.Delay(1)

    u = 0  # unpress hack
    while result == None:
        draw()
        ika.Video.ShowPage()
        ika.Input.Update()
        ika.Delay(1)
        if controls.up.pressed:
            if cursorPos > 0:
                cursorPos -= 1
            else:
                secrat += 1
                if (secrat == 6):
                    menuItems = ("New Game", "Load Game", "Quit Game", "New Game +")
                    cursorPos = 3

        elif controls.down.pressed and cursorPos < (len(menuItems) - 1):
            cursorPos += 1
        elif controls.attack1():
            result = cursorPos

    sound.newGame.Play()
    if result == 0:
        sound.newGame.Play()
    return result
