import ika
import math
import system
import player
import Brain
import animator
import sound
import dir

from enemy import Enemy
from entity import Entity

_jellyAnim = {
    'walk': ((
        animator.makeAnim((0, 1, 2, 3), 20),
        animator.makeAnim((0, 1, 2, 3), 20),
        animator.makeAnim((0, 1, 2, 3), 20),
        animator.makeAnim((0, 1, 2, 3), 20),
        animator.makeAnim((0, 1, 2, 3), 20),
        animator.makeAnim((0, 1, 2, 3), 20),
        animator.makeAnim((0, 1, 2, 3), 20),
        animator.makeAnim((0, 1, 2, 3), 20),
        ),
        True
    ),

    'grow': ((
        animator.makeAnim((4, 5, 6, 7), 20),
        animator.makeAnim((4, 5, 6, 7), 20),
        animator.makeAnim((4, 5, 6, 7), 20),
        animator.makeAnim((4, 5, 6, 7), 20),
        animator.makeAnim((4, 5, 6, 7), 20),
        animator.makeAnim((4, 5, 6, 7), 20),
        animator.makeAnim((4, 5, 6, 7), 20),
        animator.makeAnim((4, 5, 6, 7), 20),
        ),
        False
    ),

    'idle': ((
        animator.makeAnim((0, 1, 2, 3), 20),
        animator.makeAnim((0, 1, 2, 3), 20),
        animator.makeAnim((0, 1, 2, 3), 20),
        animator.makeAnim((0, 1, 2, 3), 20),
        animator.makeAnim((0, 1, 2, 3), 20),
        animator.makeAnim((0, 1, 2, 3), 20),
        animator.makeAnim((0, 1, 2, 3), 20),
        animator.makeAnim((0, 1, 2, 3), 20),
        ),
        True
    ),

    'attack': ((
        ((12, 30), (13, 15)),
        ((14, 30), (15, 15)),
        ((10, 30), (11, 15)),
        (( 8, 30), ( 9, 15)),
        ((12, 30), (13, 15)),
        ((14, 30), (15, 15)),
        ((12, 30), (13, 15)),
        ((14, 30), (15, 15)),
        ),
        False
    ),

    'hurt': ((
        ((27, 1000),),
        ((26, 1000),),
        ((24, 1000),),
        ((25, 1000),),
        ((27, 1000),),
        ((26, 1000),),
        ((27, 1000),),
        ((26, 1000),),
        ),
        False
    ),

    'die': ((
        ((38, 20), (39, 90)),
        ((33, 20), (34, 90)),
        ((23, 20), (24, 90)),
        ((28, 20), (29, 90)),
        ((38, 20), (39, 90)),
        ((33, 20), (34, 90)),
        ((38, 20), (39, 90)),
        ((33, 20), (34, 90)),
        ),
        False
    ),
}

_attackRange = [
    (-8,   0,  8, 16),
    (16,   0,  8, 16),
    ( 0, -8,  16,  8),
    ( 0,  16, 16,  8),
    (-8,   0,  8, 16),
    (16,   0,  8, 16),
    (-8,   0,  8, 16),
    (16,   0,  8, 16),
]


def createJelly(entity):
    return Jelly(entity)


class Jelly(Enemy):

    SPRITE = 'jelly.ika-sprite'

    def __init__(self, ent):
        super(Jelly, self).__init__(ent, _jellyAnim, Brain.Brain())

        # Test code:
        # Equal probability of attacking or doing nothing.
        #self.addMoods(
        #    (Brain.Attack(1), self.attackMood),
        #    (Brain.Flee(1), self.passiveMood)
        #)

        self.mood = self.growMood
        self.think()
        self.update()

        self.stats.maxhp = self.stats.hp = 50
        self.stats.att = 9
        self.stats.exp = 3

        self.stats.money = 2

        self.speed = 20

        self.adjustStats()

        #HACK

    def hurtState(self, recoilSpeed, recoilDir):
        if self.stats.hp > 0:
            sound.enemyHit.Play()

        return super(Jelly, self).hurtState(recoilSpeed, recoilDir)

    def die(self, *args):
        super(Jelly, self).die(*args)


    def growMood(self):
        while True:
            yield self.growState()

    def passiveMood(self):

        p = system.engine.player
        self._animator.kill = True
        while True:
            yield self.walkState(ika.Random(0,8), ika.Random(24,64))
            yield self.idleState(ika.Random(0,20))


    def idleState(self, *args):
        self._animator.kill = True
        return super(Jelly, self).idleState(*args)

    def growState(self):
        self.invincible = True
        self.anim = 'grow'
        while not self._animator.kill:
            yield None
        self.invincible = False
        self.mood = self.passiveMood
        self.stop()

    def walkState(self, dir, dist):
        ox, oy = self.x, self.y
        self.move(dir, dist)
        self.anim = 'walk'
        yield None
        while self.moving:
            yield None
            ents = self.detectCollision((0, 0, self.ent.hotwidth, self.ent.hotheight))
            for e in ents:
                if isinstance(e, player.Player):
                    d = max(1, self.stats.att - e.stats.pres)
                    e.hurt(d, 150, self.direction)
                    break
            if (ox, oy) == (self.x, self.y):
                break
        self.stop()

    def deathState(self, *args, **kwargs):
        sound.jellyDie.Play()
        self.anim = 'die'
        return super(Jelly, self).deathState(*args, **kwargs)
