import ika
import math
import system
import player
import Brain
import animator
import sound
import dir

import engine

from enemy import Enemy
from entity import Entity

from jelly import createJelly


_potAnim = {
    'walk': ((
        animator.makeAnim((4, 5), 3),
        animator.makeAnim((6, 7), 3),
        animator.makeAnim((2, 3), 3),
        animator.makeAnim((0, 1), 3),
        animator.makeAnim((4, 5), 3),
        animator.makeAnim((6, 7), 3),
        animator.makeAnim((4, 5), 3),
        animator.makeAnim((6, 7), 3),
        ),
        True
    ),

    'idle': ((
        ((3, 1000),),
        ((2, 1000),),
        ((1, 1000),),
        ((0, 1000),),
        ((0, 1000),),
        ((0, 1000),),
        ((0, 1000),),
        ((0, 1000),)
        ),
        True
    ),

    'attack': ((
        ((12, 30), (13, 15)),
        ((14, 30), (15, 15)),
        ((10, 30), (11, 15)),
        (( 8, 30), ( 9, 15)),
        ((12, 30), (13, 15)),
        ((14, 30), (15, 15)),
        ((12, 30), (13, 15)),
        ((14, 30), (15, 15)),
        ),
        False
    ),

    'hurt': ((
        ((3, 1000),),
        ((3, 1000),),
        ((3, 1000),),
        ((3, 1000),),
        ((3, 1000),),
        ((3, 1000),),
        ((3, 1000),),
        ((3, 1000),),
        ),
        False
    ),

    'die': ((
        ((38, 20), (39, 90)),
        ((33, 20), (34, 90)),
        ((23, 20), (24, 90)),
        ((28, 20), (29, 90)),
        ((38, 20), (39, 90)),
        ((33, 20), (34, 90)),
        ((38, 20), (39, 90)),
        ((33, 20), (34, 90)),
        ),
        False
    ),
}

_attackRange = [
    (-8,   0,  8, 16),
    (16,   0,  8, 16),
    ( 0, -8,  16,  8),
    ( 0,  16, 16,  8),
    (-8,   0,  8, 16),
    (16,   0,  8, 16),
    (-8,   0,  8, 16),
    (16,   0,  8, 16),
]


def createPot(entity):
    return Pot(entity)


class Pot(Enemy):

    SPRITE = 'pot.ika-sprite'

    def __init__(self, ent):
        super(Pot, self).__init__(ent, _potAnim, Brain.Brain())

        # Test code:
        # Equal probability of attacking or doing nothing.
        #self.addMoods(
        #    (Brain.Attack(1), self.attackMood),
        #    (Brain.Flee(1), self.passiveMood)
        #)

        self.mood = self.spawnMood
        self.stats.maxhp = self.stats.hp = 250
        self.stats.att = 1
        self.stats.exp = 15

        self.direction = dir.DOWN

        self.stats.money = 20

        self.divisor = self.stats.maxhp / 4

        self.adjustStats()

    def hurtState(self, recoilSpeed, recoilDir):
        if self.stats.hp > 0:
            sound.enemyHit.Play()

        return super(Pot, self).hurtState(0, recoilDir)

    def spawnMood(self):

        p = system.engine.player
        self._animator.kill = True
        while True:
            yield self.spawnState()
            yield self.idleState(750)


    def idleState(self, time=50):
        while time > 0:
            time -= 1
            self.anim = 'idle'
            yield None
        return

    def spawnState(self):

        x = self.ent.x
        y = self.ent.y
        tw = ika.Tileset.width
        th = ika.Tileset.height

        positions = [(x-tw, y), (x, y-th), (x+tw, y), (x, y+th)]

        num = ika.Random(0, len(positions))
        p = positions[num]

        while len(ika.EntitiesAt(p[0], p[1], tw, th, self.ent.layer)) > 1:
            num = ika.Random(0, len(positions))
            p = positions[num]
            yield None

        jelly_ent = ika.Entity(p[0], p[1], self.ent.layer, "jelly.ika-sprite")

        engine.addEntity(createJelly(jelly_ent))

        self.stop()

    def deathState(self, *args, **kwargs):
        sound.potDie.Play()
        return super(Pot, self).deathState(*args, **kwargs)

    def hurt(self, amount, recoilSpeed=0, recoilDir=None):
        if self.invincible:
            return
        if recoilDir is None:
            recoilDir = dir.invert[self.direction]
        if self.stats.hp <= amount:
            self.stats.hp = 0
            self.die()
        else:
            self.stats.hp -= amount
            sound.enemyHit.Play()
