import ika
import engine
from entity import Entity
from npc import Npc

class Yolander(Npc):
    SPRITE = 'yolander.ika-sprite'

    def activate(self):
        from mapscript import text

        yo = ika.Map.entities["yolander"]
        ana = engine.player.ent

        if 'fishconvo' not in engine.saveData and 'rescued' not in engine.saveData:
            engine.saveData['fishconvo'] = True

            text(yo, "yolander", "Oh my!  That's the biggest catch you've made all month!")
            text(ana, "anastasia3", "Yeah...  Except it's the only one I have.")
            text(yo, "yolander", "Tsk tsk, Anastasia!  How can I run a restaurant without fish?")
            text(ana, "anastasia", "I'm really sorry, Yolander.  This really hasn't been my day.  I swear, those gulls were out to get me!")
            text(yo, "yolander", "Sure, sure.  Don't worry about it.  This should be enough for today.  Here you are..")

            #need to add stats
            engine.player.stats.money += 20
            text(ana, "Recieved 20 shells!")
            text(yo, "yolander", "Don't spend it all in one place!")

        elif 'rescued' not in engine.saveData:
            text(yo, "yolander", "Have you found Friedrich yet? I haven't seen him all day..")
            text(engine.player, "anastasia", "No, not yet. Maybe I'll try looking north.")
        else:
            text(yo, "yolander", "So when are you gonna catch some more fish for your favorite customor?")
            text(engine.player, "anastasia", "Um... soon, but first I have some business to take care of.")
            text(yo, "yolander", "Okay, but just make sure none of my customers starve. I have a business to run too!")

